import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';
import {
  RESET_ADD_MVP_STATE,
  UPDATE_CONCEPT_CARD_TAB_SELECTION
} from '../../../actions';

import { TemplatingServices } from '../../../services/templating-services';

@Component({
  selector: 'app-concept-templating-tabs',
  templateUrl: './concept-templating-tabs.component.html',
  styleUrls: ['./concept-templating-tabs.component.scss']
})
export class ConceptTemplatingTabsComponent implements OnInit {
  @Input() tabs;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private templateServices: TemplatingServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  setTabSelection(tabName) {
    this.ngRedux.dispatch({
      type: UPDATE_CONCEPT_CARD_TAB_SELECTION,
      payload: tabName
    });
    this.ngRedux.dispatch({
          type: RESET_ADD_MVP_STATE
    });
  }

  isActiveTab(description) {
    var activeClass= 'nav-link active';
    var nonactiveClass= 'nav-link';
    if (description == this.getState().conceptCard.conceptCardState.selectedTab) {
      return { state : activeClass};
    } else {
      return {state: nonactiveClass};
    }
  }

  getTabIndex(tabLink) {
    return this.templateServices.getTabIndex(tabLink);
  }

  getSelectedTab() {
    return this.getState().conceptCard.conceptCardState.selectedTab;
  }
}
